/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.handlers;

import com.st.flashtool.drivers.ConnectionInfo;
import com.st.flashtool.drivers.ErrorsDescription;
import com.st.flashtool.drivers.SPCFlasherConnectDll;
import com.st.flashtool.handlers.Messages;
import com.st.flashtool.ui.views.DeviceView;
import com.st.flashtool.ui.views.VerifyOptionsDialog;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class VerifyHandler
extends AbstractHandler
implements IHandler {
    Shell activeShell = null;
    private static ConnectionInfo ci;
    private static SPCFlasherConnectDll.ProgressCallback progressCallback;
    private static SPCFlasherConnectDll.EventCallback eventCallback;
    private static DeviceView dv;
    private static VerifyOptionsDialog od;
    ErrorsDescription ed;
    int nRC;
    int nImageStartAddress;
    int nImageStartAddressHexFile;
    int nImageEndAddress;
    int nImageSize;
    int[] nImageLoaded;
    int[] nImageRead;
    int[] nImage;
    int[] nReadImage;
    File selFile;
    IProgressMonitor localMonitor;
    int step = 0;
    String stringMessage;
    int VerifyFlag = 0;
    int FirstVerifyAddress = 0;
    int FlashBlockNum = 0;
    int FlashBlockStartAddress;
    int FlashBlockEndAddress;
    int FlashBlockSize;
    int FlashBlockMirroredMask;
    boolean FlashSelected;
    int nBlockCount = 0;
    int nBlockReadCount = 0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ci = new ConnectionInfo();
        this.ed = new ErrorsDescription();
        this.step = 0;
        dv = (DeviceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                VerifyHandler.this.activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }
        });
        dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_Start);
        progressCallback = new SPCFlasherConnectDll.ProgressCallback(){

            public void invoke(int total, int current) {
                if (total == current) {
                    VerifyHandler.this.localMonitor.worked(100);
                    VerifyHandler.this.step = 0;
                } else if (100 * current / total > VerifyHandler.this.step) {
                    VerifyHandler.this.localMonitor.worked(1);
                    ++VerifyHandler.this.step;
                }
            }
        };
        eventCallback = new SPCFlasherConnectDll.EventCallback(){

            public void invoke(int event, int value) {
                if (event == 0) {
                    // empty if block
                }
            }
        };
        od = new VerifyOptionsDialog(this.activeShell);
        od.create();
        int retval = od.open();
        if (retval == 1) {
            dv.PrintSPC5FlasherConsole(Messages.Handlers_Aborted);
            dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_End);
            return null;
        }
        VerifyHandler.ci.cbSize = ci.size();
        VerifyHandler.ci.uiChannel = dv.getInterfaceChannel();
        VerifyHandler.ci.strInterface = dv.getInterface();
        VerifyHandler.ci.strDevice = dv.getTargetDevice();
        VerifyHandler.ci.FlashStartAddress = dv.getFlashStartAddress();
        VerifyHandler.ci.FlashEndAddress = dv.getFlashEndAddress();
        VerifyHandler.ci.strPWD = dv.getPassword();
        VerifyHandler.ci.strExtFreq = dv.getExternalQuartz();
        if (VerifyHandler.ci.strInterface.indexOf(Messages.Handlers_CAN) > 0) {
            VerifyHandler.ci.strSpeed = dv.getCanBaudrate(VerifyHandler.ci.strExtFreq);
        } else if (VerifyHandler.ci.strInterface.indexOf(Messages.Handlers_UART) > 0) {
            if (VerifyHandler.ci.strDevice.contains(Messages.Handlers_SPC56)) {
                VerifyHandler.ci.strSpeed = dv.getUartSPC56Baudrate(VerifyHandler.ci.strExtFreq);
            } else if (VerifyHandler.ci.strDevice.contains(Messages.Handlers_SPC57) || VerifyHandler.ci.strDevice.contains(Messages.Handlers_SPC58)) {
                VerifyHandler.ci.strSpeed = dv.getUartSPC57Baudrate(VerifyHandler.ci.strExtFreq);
            }
        } else {
            MessageDialog.open((int)4, (Shell)this.activeShell, (String)Messages.VerifyHandler_FlashTool, (String)Messages.Handlers_WrongIF, (int)0x10000000);
            VerifyHandler.ci.strSpeed = "0";
        }
        VerifyHandler.ci.bConnected = 1;
        VerifyHandler.ci.hProgramThread = null;
        VerifyHandler.ci.hProgramThreadRunning = null;
        VerifyHandler.ci.progressCallback = progressCallback;
        VerifyHandler.ci.eventCallback = eventCallback;
        this.activeShell.setCursor(new Cursor((Device)this.activeShell.getDisplay(), 1));
        if (VerifyHandler.od.verifyByBlock) {
            if (!dv.GetImageLoadedFlag()) {
                dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_PleaseSelect);
                dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_End);
                this.activeShell.setCursor(null);
                return false;
            }
            dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_StartOnSelection);
            this.FlashBlockNum = dv.getFlashBlockNumber();
            this.nBlockCount = 0;
            while (this.nBlockCount < this.FlashBlockNum) {
                this.FlashBlockStartAddress = dv.getFlashBlockStartAddress(this.nBlockCount);
                this.FlashBlockEndAddress = dv.getFlashBlockEndAddress(this.nBlockCount);
                this.FlashBlockSize = this.FlashBlockEndAddress - this.FlashBlockStartAddress + 1;
                this.FlashBlockMirroredMask = dv.getFlashBlockMirroredMask(this.nBlockCount);
                this.FlashSelected = dv.getFlashBlockSelection(this.nBlockCount);
                if (this.FlashSelected) {
                    this.stringMessage = String.format("Flash Block selected -> block number %d Start Address: 0x%08X End Address: 0x%08X ", this.nBlockCount, this.FlashBlockStartAddress, this.FlashBlockEndAddress);
                    dv.PrintSPC5FlasherConsole(this.stringMessage);
                    this.nImageLoaded = new int[this.FlashBlockSize];
                    final int nImageLoadedStartAddress = dv.GetImageStartAddress(this.nBlockCount);
                    final int nImageLoadedEndAddress = dv.GetImageEndAddress(this.nBlockCount);
                    final int nImageLoadedSize = nImageLoadedEndAddress - nImageLoadedStartAddress + 1;
                    int i = 0;
                    while (i < nImageLoadedSize) {
                        this.nImageLoaded[i] = dv.GetFlashBlockData(this.nBlockCount, i);
                        ++i;
                    }
                    try {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.activeShell);
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                VerifyHandler.this.localMonitor = monitor;
                                PointerByReference Image = new PointerByReference();
                                monitor.beginTask(Messages.Handlers_Verifying, 50);
                                if (VerifyHandler.this.FlashBlockMirroredMask == 0) {
                                    ci.StartAddress = nImageLoadedStartAddress;
                                    ci.EndAddress = nImageLoadedEndAddress;
                                } else {
                                    ci.StartAddress = nImageLoadedStartAddress & VerifyHandler.this.FlashBlockMirroredMask;
                                    ci.EndAddress = nImageLoadedEndAddress & VerifyHandler.this.FlashBlockMirroredMask;
                                }
                                SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
                                VerifyHandler.this.nRC = fdll.ReadMemory(ci, Image);
                                if (VerifyHandler.this.nRC == 0) {
                                    Pointer ImagepVals = Image.getValue();
                                    VerifyHandler.this.nImageRead = new int[nImageLoadedSize];
                                    int i = 0;
                                    while (i < nImageLoadedSize - 1) {
                                        VerifyHandler.this.nImageRead[i] = ImagepVals.getInt((long)(i * Native.getNativeSize(Integer.TYPE)));
                                        ++i;
                                    }
                                    i = 0;
                                    while (i < nImageLoadedSize - 1 && VerifyHandler.this.VerifyFlag == 0) {
                                        if ((VerifyHandler.this.nImageLoaded[i] & 0xFF) != (VerifyHandler.this.nImageRead[i] & 0xFF)) {
                                            VerifyHandler.this.VerifyFlag = 1;
                                            VerifyHandler.this.FirstVerifyAddress = VerifyHandler.this.FlashBlockStartAddress + i;
                                            continue;
                                        }
                                        ++i;
                                    }
                                    if (VerifyHandler.this.VerifyFlag == 0) {
                                        dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_SuccessBlockIdentical);
                                    } else {
                                        VerifyHandler.this.stringMessage = String.format(Messages.VerifyHandler_SuccessBlockNotIdentical, VerifyHandler.this.FirstVerifyAddress);
                                        dv.PrintSPC5FlasherConsole(VerifyHandler.this.stringMessage);
                                    }
                                } else {
                                    String stringMessage = VerifyHandler.this.ed.getErrorDescription(VerifyHandler.this.nRC & 0xFFFF);
                                    dv.PrintSPC5FlasherConsole(stringMessage);
                                }
                                monitor.done();
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        this.nRC = -1;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this.nRC = -1;
                    }
                }
                ++this.nBlockCount;
            }
        } else if (VerifyHandler.od.verifyByAddress) {
            Pointer ImagepVals;
            String pathName;
            SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
            String filename = String.valueOf(File.separator) + Messages.Handlers_tmp;
            FileDialog openFileDialog = new FileDialog(this.activeShell, 4096);
            openFileDialog.setFilterNames(new String[]{Messages.Handlers_HexFiles, Messages.Handlers_S19Files, Messages.Handlers_AllFiles});
            openFileDialog.setFilterExtensions(new String[]{Messages.Handlers_Hex, Messages.Handlers_S19, Messages.Handlers_All});
            openFileDialog.setFilterPath(Messages.Handlers_CDisk);
            openFileDialog.setFileName(filename);
            String fn = openFileDialog.open();
            if (fn != null) {
                pathName = openFileDialog.getFilterPath();
                if (pathName.charAt(pathName.length() - 1) != File.separatorChar) {
                    pathName = String.valueOf(pathName) + File.separatorChar;
                }
            } else {
                dv.PrintSPC5FlasherConsole(Messages.Handlers_Aborted);
                dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_End);
                this.activeShell.setCursor(null);
                return true;
            }
            String selFileName = String.valueOf(pathName) + openFileDialog.getFileName();
            VerifyHandler.ci.strHexFileName = selFileName;
            String stringMessage = String.format("Image file name: %s", selFileName);
            dv.PrintSPC5FlasherConsole(stringMessage);
            dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_StartAddr);
            IntByReference StartAddress = new IntByReference(0);
            IntByReference StartAddressHexFile = new IntByReference(0);
            IntByReference EndAddress = new IntByReference(0);
            String strHexFileName = selFileName;
            int flahStartAddress = dv.getFlashStartAddress();
            int flahEndAddress = dv.getFlashEndAddress();
            int flahsize = flahEndAddress - flahStartAddress + 1;
            PointerByReference Image = new PointerByReference();
            int flashMirrorMask = 0xFFFFFFF;
            int flashMirroredStartAddress = dv.getFlashMirroredStartAddress();
            if (flashMirroredStartAddress != 0) {
                flashMirrorMask = dv.getFlashMirroredStartAddress() - dv.getFlashStartAddress() - 1;
            }
            this.nRC = fdll.ParseHexFile(flahStartAddress, flahsize, flashMirrorMask, strHexFileName, StartAddress, EndAddress, StartAddressHexFile, Image);
            if (this.nRC == 0) {
                this.nImageStartAddress = StartAddress.getValue();
                this.nImageEndAddress = EndAddress.getValue();
                this.nImageSize = this.nImageEndAddress - this.nImageStartAddress + 1;
                this.nImageStartAddressHexFile = StartAddressHexFile.getValue();
                ImagepVals = Image.getValue();
                this.nImage = new int[this.nImageSize];
                int i = 0;
                while (i < this.nImageSize) {
                    this.nImage[i] = ImagepVals.getInt((long)(i * Native.getNativeSize(Integer.TYPE)));
                    ++i;
                }
            } else {
                dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_FileFormatError);
                dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_End);
                this.activeShell.setCursor(null);
                return null;
            }
            fdll.CleanImage(ImagepVals);
            stringMessage = String.format("Start Address: 0x%08X End Address: 0x%08X Size: 0x%08X ", this.nImageStartAddressHexFile, this.nImageStartAddressHexFile + this.nImageSize - 1, this.nImageSize);
            dv.PrintSPC5FlasherConsole(stringMessage);
            VerifyHandler.ci.StartAddress = this.nImageStartAddress;
            VerifyHandler.ci.EndAddress = this.nImageEndAddress;
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.activeShell);
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        VerifyHandler.this.localMonitor = monitor;
                        PointerByReference Image = new PointerByReference();
                        monitor.beginTask(Messages.VerifyHandler_Ongoing, 200);
                        SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
                        VerifyHandler.this.nRC = fdll.ReadMemory(ci, Image);
                        if (VerifyHandler.this.nRC == 0) {
                            Pointer ImagepVals = Image.getValue();
                            VerifyHandler.this.nReadImage = new int[ci.EndAddress - ci.StartAddress + 1];
                            int i = 0;
                            while (i < ci.EndAddress - ci.StartAddress) {
                                VerifyHandler.this.nReadImage[i] = ImagepVals.getInt((long)(i * Native.getNativeSize(Integer.TYPE)));
                                ++i;
                            }
                        } else {
                            String stringMessage = VerifyHandler.this.ed.getErrorDescription(VerifyHandler.this.nRC & 0xFFFF);
                            dv.PrintSPC5FlasherConsole(stringMessage);
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                this.nRC = -1;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.nRC = -1;
            }
            int i = 0;
            while (i < VerifyHandler.ci.EndAddress - VerifyHandler.ci.StartAddress && this.VerifyFlag == 0) {
                if ((this.nReadImage[i] & 0xFF) != (this.nImage[i] & 0xFF)) {
                    this.VerifyFlag = 1;
                    this.FirstVerifyAddress = this.nImageStartAddressHexFile + i;
                    continue;
                }
                ++i;
            }
            if (this.VerifyFlag == 0) {
                dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_SuccessIdentical);
            } else {
                stringMessage = String.format(Messages.VerifyHandler_SuccessNotIdentical, this.FirstVerifyAddress);
                dv.PrintSPC5FlasherConsole(stringMessage);
            }
        } else {
            dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_NoSelection);
            dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_End);
            this.activeShell.setCursor(null);
            return null;
        }
        this.activeShell.setCursor(null);
        dv.PrintSPC5FlasherConsole(Messages.VerifyHandler_End);
        return null;
    }
}

