/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.handlers;

import com.st.flashtool.drivers.ErrorsDescription;
import com.st.flashtool.drivers.SPCFlasherConnectDll;
import com.st.flashtool.handlers.Messages;
import com.st.flashtool.ui.views.DeviceView;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class LoadImageHandler
extends AbstractHandler {
    private static DeviceView dv;
    int nRC;
    ErrorsDescription ed;
    int nImageStartAddress;
    int nImageEndAddress;
    int nImageSize;
    int[] nImage;
    int[] nReadImage;
    File selFile;
    IProgressMonitor localMonitor;
    String stringMessage;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String pathName;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        dv = (DeviceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.stringMessage = String.format(Messages.LoadImageHandler_StartLoading, new Object[0]);
        dv.PrintSPC5FlasherConsole(this.stringMessage);
        this.ed = new ErrorsDescription();
        String filename = String.valueOf(File.separator) + Messages.Handlers_tmp;
        FileDialog openFileDialog = new FileDialog(window.getShell(), 4096);
        openFileDialog.setFilterNames(new String[]{Messages.Handlers_HexFiles, Messages.Handlers_S19Files, Messages.Handlers_AllFiles});
        openFileDialog.setFilterExtensions(new String[]{Messages.Handlers_Hex, Messages.Handlers_S19, Messages.Handlers_All});
        openFileDialog.setFilterPath(Messages.Handlers_CDisk);
        openFileDialog.setFileName(filename);
        String fn = openFileDialog.open();
        if (fn != null) {
            pathName = openFileDialog.getFilterPath();
            if (pathName.charAt(pathName.length() - 1) != File.separatorChar) {
                pathName = String.valueOf(pathName) + File.separatorChar;
            }
        } else {
            this.stringMessage = Messages.LoadImageHandler_aborted;
            dv.PrintSPC5FlasherConsole(this.stringMessage);
            return true;
        }
        String selFileName = String.valueOf(pathName) + openFileDialog.getFileName();
        window.getShell().setCursor(new Cursor((Device)window.getShell().getDisplay(), 1));
        this.stringMessage = String.format(Messages.LoadImageHandler_ImageName, selFileName);
        dv.PrintSPC5FlasherConsole(this.stringMessage);
        IntByReference StartAddress = new IntByReference(0);
        IntByReference EndAddress = new IntByReference(0);
        String strHexFileName = selFileName;
        PointerByReference Image = new PointerByReference();
        int FlashBlockNum = dv.getFlashBlockNumber();
        dv.InitFlashBlockMapArray();
        int nBlockCount = 0;
        while (nBlockCount < FlashBlockNum) {
            int FlashBlockStartAddress = dv.getFlashBlockStartAddress(nBlockCount);
            int FlashBlockEndAddress = dv.getFlashBlockEndAddress(nBlockCount);
            int FlashBlockSize = FlashBlockEndAddress - FlashBlockStartAddress + 1;
            this.stringMessage = String.format(Messages.LoadImageHandler_BlockRange, nBlockCount, FlashBlockStartAddress, FlashBlockEndAddress);
            dv.PrintSPC5FlasherConsole(this.stringMessage);
            SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
            this.nRC = fdll.ParseHexFile_FlashBlock(FlashBlockStartAddress, FlashBlockSize, strHexFileName, StartAddress, EndAddress, Image);
            if (this.nRC == 0) {
                this.nImageStartAddress = StartAddress.getValue();
                this.nImageEndAddress = EndAddress.getValue();
                this.nImageSize = this.nImageEndAddress - this.nImageStartAddress + 1;
                dv.SetImageStartAddress(nBlockCount, this.nImageStartAddress);
                dv.SetImageEndAddress(nBlockCount, this.nImageEndAddress);
                if (this.nImageStartAddress == this.nImageEndAddress) {
                    dv.SelectFlashBlock(nBlockCount, false);
                    this.stringMessage = String.format(Messages.LoadImageHandler_NoData, new Object[0]);
                    dv.PrintSPC5FlasherConsole(this.stringMessage);
                } else {
                    dv.SelectFlashBlock(nBlockCount, true);
                    Pointer ImagepVals = Image.getValue();
                    this.nImage = new int[this.nImageSize];
                    int i = 0;
                    while (i < this.nImageSize) {
                        this.nImage[i] = ImagepVals.getInt((long)(i * Native.getNativeSize(Integer.TYPE)));
                        dv.LoadFlashBlockData(nBlockCount, i, this.nImage[i]);
                        ++i;
                    }
                    fdll.CleanImage(ImagepVals);
                    this.stringMessage = String.format(Messages.LoadImageHandler_LoadedRange, this.nImageStartAddress, this.nImageEndAddress, this.nImageSize);
                    dv.PrintSPC5FlasherConsole(this.stringMessage);
                    dv.SetImageFileName(strHexFileName);
                    dv.SetImageLoadedFlag(true);
                    dv.EnableProgramCommand(true);
                }
            } else {
                this.stringMessage = Messages.LoadImageHandler_FileFormatError;
                dv.PrintSPC5FlasherConsole(this.stringMessage);
                dv.SetImageLoadedFlag(false);
                dv.EnableProgramCommand(false);
            }
            ++nBlockCount;
        }
        window.getShell().setCursor(null);
        dv.PrintSPC5FlasherConsole(Messages.LoadImageHandler_LoadingEnd);
        return null;
    }
}

