/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.handlers;

import com.st.flashtool.drivers.ConnectionInfo;
import com.st.flashtool.drivers.ErrorsDescription;
import com.st.flashtool.drivers.FlasherInterfaces;
import com.st.flashtool.drivers.SPCFlasherConnectDll;
import com.st.flashtool.handlers.Messages;
import com.st.flashtool.ui.views.DeviceView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DisconnectHandler
extends AbstractHandler {
    private static ConnectionInfo ci;
    private static SPCFlasherConnectDll.ProgressCallback progressCallback;
    private static SPCFlasherConnectDll.EventCallback eventCallback;
    ErrorsDescription ed;
    DeviceView dv;
    MessageDialog dlg;
    int nRC;
    IProgressMonitor localMonitor;
    int step = 0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String stringMessage;
        this.ed = new ErrorsDescription();
        this.step = 0;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.dv = (DeviceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.dv.PrintSPC5FlasherConsole(Messages.DisconnectHandler_StartDisconnection);
        this.dv.DeseclectAllBlocks();
        this.dv.SetImageFileName("");
        progressCallback = new SPCFlasherConnectDll.ProgressCallback(){

            public void invoke(int total, int current) {
                if (total == current) {
                    DisconnectHandler.this.localMonitor.worked(100);
                    DisconnectHandler.this.step = 0;
                } else if (100 * current / total > DisconnectHandler.this.step) {
                    DisconnectHandler.this.localMonitor.worked(1);
                    ++DisconnectHandler.this.step;
                }
            }
        };
        eventCallback = new SPCFlasherConnectDll.EventCallback(){

            public void invoke(int event, int value) {
                if (event == 0) {
                    if (value == 0) {
                        System.out.printf(Messages.DisconnectHandler_DisconnectedOK, new Object[0]);
                    } else {
                        System.out.printf(Messages.DisconnectHandler_ErrorDisconnecting, value);
                    }
                } else {
                    System.out.printf(Messages.DisconnectHandler_EventNotified, event, value);
                }
            }
        };
        window.getShell().setCursor(new Cursor((Device)window.getShell().getDisplay(), 1));
        ci = new ConnectionInfo();
        DisconnectHandler.ci.cbSize = ci.size();
        DisconnectHandler.ci.uiChannel = this.dv.getInterfaceChannel();
        DisconnectHandler.ci.strInterface = this.dv.getInterface();
        DisconnectHandler.ci.bConnected = 1;
        DisconnectHandler.ci.hProgramThread = null;
        DisconnectHandler.ci.hProgramThreadRunning = null;
        DisconnectHandler.ci.progressCallback = progressCallback;
        DisconnectHandler.ci.eventCallback = eventCallback;
        DisconnectHandler.ci.NInterfaces = FlasherInterfaces.getNInterfaces();
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    DisconnectHandler.this.localMonitor = monitor;
                    monitor.beginTask(Messages.DisconnectHandler_Disconnecting, 100);
                    SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
                    DisconnectHandler.this.nRC = fdll.Disconnect(ci);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        if (this.nRC == 0) {
            stringMessage = Messages.DisconnectHandler_SuccessfullyDisconnected;
            this.dv.PrintSPC5FlasherConsole(stringMessage);
            this.dv.updateUI(false);
            this.dv.isConnected = false;
        } else {
            this.dv.updateUI(true);
            this.dv.isConnected = true;
            stringMessage = this.ed.getErrorDescription(this.nRC & 0xFFFF);
            this.dv.PrintSPC5FlasherConsole(stringMessage);
        }
        window.getShell().setCursor(null);
        this.dv.PrintSPC5FlasherConsole(Messages.DisconnectHandler_DisconnectEnd);
        return null;
    }
}

