/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.handlers;

import com.st.flashtool.drivers.ConnectionInfo;
import com.st.flashtool.drivers.ErrorsDescription;
import com.st.flashtool.drivers.FlasherInterfaces;
import com.st.flashtool.drivers.SPCFlasherConnectDll;
import com.st.flashtool.handlers.Messages;
import com.st.flashtool.ui.views.DeviceView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConnectHandler
extends AbstractHandler {
    private static ConnectionInfo ci;
    private static SPCFlasherConnectDll.ProgressCallback progressCallback;
    private static SPCFlasherConnectDll.EventCallback eventCallback;
    DeviceView dv;
    ErrorsDescription ed;
    int nParamAddress = 0;
    byte[] nParamValue = new byte[5];
    int nParamNumber;
    int ParamBaseAddress;
    int nRC = 0;
    IProgressMonitor localMonitor;
    int step = 0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.ed = new ErrorsDescription();
        this.step = 0;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.dv = (DeviceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.dv.SetImageLoadedFlag(false);
        if (this.dv.getInterfaceChannel() == 0) {
            String stringMessage = Messages.ConnectHandler_SelectValidIF;
            MessageDialog.open((int)4, (Shell)window.getShell(), (String)Messages.Handlers_Title, (String)stringMessage, (int)0x10000000);
            return null;
        }
        String stringMessage = String.format(Messages.ConnectHandler_Start, this.dv.getTargetDevice(), this.dv.getExternalQuartz(), this.dv.getInterface());
        this.dv.PrintSPC5FlasherConsole(stringMessage);
        if (this.dv.getTargetDevice().matches(Messages.ConnectHandler_NA)) {
            this.dv.PrintSPC5FlasherConsole(Messages.ConnectHandler_ErrorLoading);
            return null;
        }
        stringMessage = this.dv.getTargetDevice().contains(Messages.Handlers_SPC57) || this.dv.getTargetDevice().contains(Messages.Handlers_SPC58) ? String.format(Messages.ConnectHandler_CheckBootHeader, this.dv.getTargetDevice(), this.dv.getExternalQuartz(), this.dv.getInterface()) : String.format(Messages.ConnectHandler_CheckBAM, this.dv.getTargetDevice(), this.dv.getExternalQuartz(), this.dv.getInterface());
        boolean retVal = MessageDialog.open((int)2, (Shell)window.getShell(), (String)Messages.Handlers_Title, (String)stringMessage, (int)0x10000000);
        if (!retVal) {
            this.dv.PrintSPC5FlasherConsole(Messages.Handlers_Aborted);
            return null;
        }
        progressCallback = new SPCFlasherConnectDll.ProgressCallback(){

            public void invoke(int total, int current) {
                if (total == current) {
                    ConnectHandler.this.localMonitor.worked(100);
                    ConnectHandler.this.step = 0;
                } else if (100 * current / total > ConnectHandler.this.step) {
                    ConnectHandler.this.localMonitor.worked(1);
                    ++ConnectHandler.this.step;
                }
            }
        };
        eventCallback = new SPCFlasherConnectDll.EventCallback(){

            public void invoke(int event, int value) {
                if (event == 0) {
                    // empty if block
                }
            }
        };
        window.getShell().setCursor(new Cursor((Device)window.getShell().getDisplay(), 1));
        ci = new ConnectionInfo();
        ConnectHandler.ci.cbSize = ci.size();
        ConnectHandler.ci.uiChannel = this.dv.getInterfaceChannel();
        ConnectHandler.ci.strInterface = this.dv.getInterface();
        ConnectHandler.ci.strDevice = this.dv.getTargetDevice();
        ConnectHandler.ci.strExtFreq = this.dv.getExternalQuartz();
        ConnectHandler.ci.strPWD = this.dv.getPassword();
        ConnectHandler.ci.strFlashSize = "";
        ConnectHandler.ci.strHexFileName = "";
        ConnectHandler.ci.nAutoBaudrate = this.dv.getAutoBaudrate() != false ? 1 : 0;
        ConnectHandler.ci.nTxFast = this.dv.getTxFast() != false ? 1 : 0;
        ConnectHandler.ci.nAlternateTx = this.dv.getAlternateTx() != false ? 1 : 0;
        ConnectHandler.ci.nKLine = this.dv.getKLine() != false ? 1 : 0;
        ConnectHandler.ci.nASCCAN = this.dv.getASCCAN() != false ? 1 : 0;
        ConnectHandler.ci.RAMStartAddress = this.dv.getRAMStartAddress();
        ConnectHandler.ci.RAMSize = this.dv.getRAMSize();
        ConnectHandler.ci.hProgramThread = null;
        ConnectHandler.ci.hProgramThreadRunning = null;
        ConnectHandler.ci.progressCallback = progressCallback;
        ConnectHandler.ci.eventCallback = eventCallback;
        ConnectHandler.ci.NInterfaces = FlasherInterfaces.getNInterfaces();
        ConnectHandler.ci.bConnected = 0;
        ConnectHandler.ci.BAFOptionBit = ConnectHandler.ci.strDevice.contains(Messages.Handlers_SPC57) || ConnectHandler.ci.strDevice.contains(Messages.Handlers_SPC58) ? 1 : 0;
        if (ConnectHandler.ci.strInterface.contains(Messages.Handlers_UART)) {
            this.nParamNumber = this.dv.GetPluginNParametersUART();
            this.ParamBaseAddress = this.dv.GetPluginBaseAddressParametersUART();
        } else if (ConnectHandler.ci.strInterface.contains(Messages.Handlers_CAN)) {
            this.nParamNumber = this.dv.GetPluginNParametersCAN();
            this.ParamBaseAddress = this.dv.GetPluginBaseAddressParametersCAN();
        } else {
            this.nParamNumber = 0;
            this.ParamBaseAddress = 0;
        }
        if (this.nParamNumber > 5) {
            MessageDialog.open((int)4, (Shell)window.getShell(), (String)Messages.Handlers_Title, (String)Messages.ConnectHandler_WrongNParams, (int)0x10000000);
            return null;
        }
        if (this.nParamNumber > 0) {
            this.nParamAddress = this.ParamBaseAddress;
            try {
                this.nParamValue[0] = (byte)Integer.parseInt(this.dv.getExternalQuartz(), 10);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (this.nParamNumber > 1) {
            this.nParamValue[1] = ConnectHandler.ci.strInterface.indexOf(Messages.Handlers_UART) > 0 ? 0 : (ConnectHandler.ci.strInterface.indexOf(Messages.Handlers_CAN) > 0 ? 1 : 2);
        }
        if (this.nParamNumber > 2) {
            this.nParamValue[2] = (byte)ConnectHandler.ci.nTxFast;
            if ((byte)ConnectHandler.ci.nTxFast == 1 && ConnectHandler.ci.strInterface.indexOf(Messages.ConnectHandler_FTDI) > 0) {
                this.nParamValue[2] = 2;
            }
        }
        if (this.nParamNumber > 3) {
            this.nParamValue[3] = (byte)ConnectHandler.ci.nKLine;
        }
        if (this.nParamNumber > 4) {
            this.nParamValue[4] = (byte)ConnectHandler.ci.nAlternateTx;
        }
        if (ConnectHandler.ci.strInterface.indexOf(Messages.Handlers_CAN) > 0) {
            ConnectHandler.ci.strSpeed = this.dv.getCanBaudrate(ConnectHandler.ci.strExtFreq);
        } else if (ConnectHandler.ci.strInterface.indexOf(Messages.Handlers_UART) > 0) {
            if (ConnectHandler.ci.strDevice.contains(Messages.Handlers_SPC56)) {
                ConnectHandler.ci.strSpeed = this.dv.getUartSPC56Baudrate(ConnectHandler.ci.strExtFreq);
            } else if (ConnectHandler.ci.strDevice.contains(Messages.Handlers_SPC57) || ConnectHandler.ci.strDevice.contains(Messages.Handlers_SPC58)) {
                ConnectHandler.ci.strSpeed = this.dv.getUartSPC57Baudrate(ConnectHandler.ci.strExtFreq);
            }
        } else {
            MessageDialog.open((int)4, (Shell)window.getShell(), (String)Messages.Handlers_Title, (String)Messages.Handlers_WrongIF, (int)0x10000000);
            ConnectHandler.ci.strSpeed = "0";
            this.dv.PrintSPC5FlasherConsole(Messages.ConnectHandler_InvalidIF);
            this.dv.PrintSPC5FlasherConsole(Messages.ConnectHandler_ConnectionEnd);
            return null;
        }
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    ConnectHandler.this.localMonitor = monitor;
                    if (ci.strDevice.contains(Messages.Handlers_SPC57) || ci.strDevice.contains(Messages.Handlers_SPC58)) {
                        monitor.beginTask(Messages.ConnectHandler_BAFLoading, 100);
                    } else {
                        monitor.beginTask(Messages.ConnectHandler_BAMLoading, 100);
                    }
                    SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
                    ConnectHandler.this.nRC = fdll.LoadPlugin(ci, ConnectHandler.this.nParamNumber, ConnectHandler.this.nParamAddress, ConnectHandler.this.nParamValue);
                    monitor.done();
                }
            });
            dialog.close();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        if (this.nRC == 0) {
            stringMessage = Messages.ConnectHandler_TargetConnectedOK;
            this.dv.PrintSPC5FlasherConsole(stringMessage);
            this.dv.updateUI(true);
            this.dv.isConnected = true;
        } else {
            this.dv.updateUI(false);
            this.dv.isConnected = false;
            stringMessage = this.ed.getErrorDescription(this.nRC & 0xFFFF);
            this.dv.PrintSPC5FlasherConsole(stringMessage);
        }
        window.getShell().setCursor(null);
        this.dv.PrintSPC5FlasherConsole(Messages.ConnectHandler_ConnectionEnd);
        return null;
    }
}

