/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.handlers;

import com.st.flashtool.drivers.ConnectionInfo;
import com.st.flashtool.drivers.ErrorsDescription;
import com.st.flashtool.drivers.SPCFlasherConnectDll;
import com.st.flashtool.handlers.Messages;
import com.st.flashtool.ui.views.DeviceView;
import com.sun.jna.ptr.IntByReference;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class BlankCheckHandler
extends AbstractHandler
implements IHandler {
    ErrorsDescription ed;
    private static ConnectionInfo ci;
    private static SPCFlasherConnectDll.ProgressCallback progressCallback;
    private static SPCFlasherConnectDll.EventCallback eventCallback;
    DeviceView dv;
    int FlashBlockNum = 0;
    String stringMessage = "";
    int[] bFlashBlockStartAddress;
    int[] bFlashBlockEndAddress;
    int[] bFlashBlockSize;
    int[] bFlashBlockMirroredMask;
    boolean[] bFlashSelected;
    int nRC;
    IProgressMonitor localMonitor;
    int step = 0;
    int nBlockCount = 0;
    String strFirstBlankCheckAddress;
    int BCFlag = 0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.ed = new ErrorsDescription();
        this.step = 0;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.dv = (DeviceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.dv.PrintSPC5FlasherConsole("Start blanck check.");
        progressCallback = new SPCFlasherConnectDll.ProgressCallback(){

            public void invoke(int total, int current) {
                int n = BlankCheckHandler.this.step;
                while (n <= (BlankCheckHandler.this.nBlockCount + 1) * current / BlankCheckHandler.this.FlashBlockNum) {
                    BlankCheckHandler.this.localMonitor.worked(1);
                    ++n;
                    ++n;
                }
                BlankCheckHandler.this.step = n;
            }
        };
        eventCallback = new SPCFlasherConnectDll.EventCallback(){

            public void invoke(int event, int value) {
                if (event == 0) {
                    // empty if block
                }
            }
        };
        window.getShell().setCursor(new Cursor((Device)window.getShell().getDisplay(), 1));
        ci = new ConnectionInfo();
        BlankCheckHandler.ci.cbSize = ci.size();
        BlankCheckHandler.ci.uiChannel = this.dv.getInterfaceChannel();
        BlankCheckHandler.ci.strInterface = this.dv.getInterface();
        BlankCheckHandler.ci.strDevice = this.dv.getTargetDevice();
        BlankCheckHandler.ci.FlashStartAddress = this.dv.getFlashStartAddress();
        BlankCheckHandler.ci.FlashEndAddress = this.dv.getFlashEndAddress();
        BlankCheckHandler.ci.bConnected = 1;
        BlankCheckHandler.ci.hProgramThread = null;
        BlankCheckHandler.ci.hProgramThreadRunning = null;
        BlankCheckHandler.ci.progressCallback = progressCallback;
        BlankCheckHandler.ci.eventCallback = eventCallback;
        this.FlashBlockNum = this.dv.getFlashBlockNumber();
        this.bFlashBlockStartAddress = new int[this.FlashBlockNum];
        this.bFlashBlockEndAddress = new int[this.FlashBlockNum];
        this.bFlashBlockSize = new int[this.FlashBlockNum];
        this.bFlashBlockMirroredMask = new int[this.FlashBlockNum];
        this.bFlashSelected = new boolean[this.FlashBlockNum];
        this.nBlockCount = 0;
        while (this.nBlockCount < this.FlashBlockNum) {
            this.bFlashBlockStartAddress[this.nBlockCount] = this.dv.getFlashBlockStartAddress(this.nBlockCount);
            this.bFlashBlockEndAddress[this.nBlockCount] = this.dv.getFlashBlockEndAddress(this.nBlockCount);
            this.bFlashBlockSize[this.nBlockCount] = this.bFlashBlockEndAddress[this.nBlockCount] - this.bFlashBlockStartAddress[this.nBlockCount] + 1;
            this.bFlashBlockMirroredMask[this.nBlockCount] = this.dv.getFlashBlockMirroredMask(this.nBlockCount);
            this.bFlashSelected[this.nBlockCount] = this.dv.getFlashBlockSelection(this.nBlockCount);
            ++this.nBlockCount;
        }
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 */
                public void run(IProgressMonitor monitor) {
                    BlankCheckHandler.this.localMonitor = monitor;
                    monitor.beginTask(Messages.BlankCheckHandler_Checking, 50);
                    BlankCheckHandler.this.nBlockCount = 0;
                    while (BlankCheckHandler.this.nBlockCount < BlankCheckHandler.this.FlashBlockNum) {
                        block7: {
                            if (BlankCheckHandler.this.bFlashSelected[BlankCheckHandler.this.nBlockCount]) {
                                String stringMessage;
                                if (BlankCheckHandler.this.bFlashBlockMirroredMask[BlankCheckHandler.this.nBlockCount] == 0) {
                                    ci.StartAddress = BlankCheckHandler.this.bFlashBlockStartAddress[BlankCheckHandler.this.nBlockCount];
                                    ci.EndAddress = BlankCheckHandler.this.bFlashBlockEndAddress[BlankCheckHandler.this.nBlockCount];
                                } else {
                                    ci.StartAddress = BlankCheckHandler.this.bFlashBlockStartAddress[BlankCheckHandler.this.nBlockCount] & BlankCheckHandler.this.bFlashBlockMirroredMask[BlankCheckHandler.this.nBlockCount];
                                    ci.EndAddress = BlankCheckHandler.this.bFlashBlockEndAddress[BlankCheckHandler.this.nBlockCount] & BlankCheckHandler.this.bFlashBlockMirroredMask[BlankCheckHandler.this.nBlockCount];
                                }
                                IntByReference FirstBlankCheckAddress = new IntByReference(0);
                                IntByReference BlankCheckFlag = new IntByReference(0);
                                SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
                                BlankCheckHandler.this.nRC = fdll.BlankCheck(BlankCheckFlag, FirstBlankCheckAddress, ci);
                                if (BlankCheckHandler.this.nRC == 0) {
                                    stringMessage = "";
                                    BlankCheckHandler.this.BCFlag = BlankCheckFlag.getValue();
                                    stringMessage = BlankCheckHandler.this.BCFlag == 1 ? (BlankCheckHandler.this.strFirstBlankCheckAddress = String.format(Messages.BlankCheckHandler_NotBlank, BlankCheckHandler.this.nBlockCount, BlankCheckHandler.this.bFlashBlockStartAddress[BlankCheckHandler.this.nBlockCount], BlankCheckHandler.this.bFlashBlockEndAddress[BlankCheckHandler.this.nBlockCount], FirstBlankCheckAddress.getValue())) : (BlankCheckHandler.this.BCFlag == 0 ? String.format(Messages.BlankCheckHandler_IsBlank, BlankCheckHandler.this.nBlockCount, BlankCheckHandler.this.bFlashBlockStartAddress[BlankCheckHandler.this.nBlockCount], BlankCheckHandler.this.bFlashBlockEndAddress[BlankCheckHandler.this.nBlockCount]) : String.format(Messages.BlankCheckHandler_ErrorWhileBlankChecking, new Object[0]));
                                    BlankCheckHandler.this.dv.PrintSPC5FlasherConsole(stringMessage);
                                    break block7;
                                } else {
                                    stringMessage = BlankCheckHandler.this.ed.getErrorDescription(BlankCheckHandler.this.nRC & 0xFFFF);
                                    BlankCheckHandler.this.dv.PrintSPC5FlasherConsole(stringMessage);
                                    break;
                                }
                            }
                            BlankCheckHandler.this.stringMessage = String.format(Messages.BlankCheckHandler_BlockNotChecked, BlankCheckHandler.this.nBlockCount, BlankCheckHandler.this.bFlashBlockStartAddress[BlankCheckHandler.this.nBlockCount], BlankCheckHandler.this.bFlashBlockEndAddress[BlankCheckHandler.this.nBlockCount]);
                            BlankCheckHandler.this.dv.PrintSPC5FlasherConsole(BlankCheckHandler.this.stringMessage);
                            int n = BlankCheckHandler.this.step;
                            while (n <= (BlankCheckHandler.this.nBlockCount + 1) * 100 / BlankCheckHandler.this.FlashBlockNum) {
                                BlankCheckHandler.this.localMonitor.worked(1);
                                ++n;
                                ++n;
                            }
                            BlankCheckHandler.this.step = n;
                        }
                        ++BlankCheckHandler.this.nBlockCount;
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        window.getShell().setCursor(null);
        this.dv.PrintSPC5FlasherConsole(Messages.BlankCheckHandler_CheckEnd);
        return null;
    }
}

