/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.ui.views;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VerifyOptionsDialog
extends TitleAreaDialog {
    public boolean verifyByBlock = false;
    public boolean verifyByAddress = true;
    private Button verifyByBlockButton;
    private Button verifyByAddressButton;
    static int ID_BLCK = 1102;
    static int ID_ADDR = 1103;

    public VerifyOptionsDialog(Shell parent) {
        super(parent);
    }

    public void create() {
        super.create();
        this.setTitle("SPC5 Flash Programmer - Verify Options");
        this.setMessage("Please select the verify options:", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createRadioBtns(container);
        area.pack();
        return area;
    }

    private void createRadioBtns(Composite container) {
        GridData dataBtn1 = new GridData();
        dataBtn1.grabExcessHorizontalSpace = true;
        dataBtn1.horizontalAlignment = 4;
        GridData dataBtn2 = new GridData();
        dataBtn2.grabExcessHorizontalSpace = true;
        dataBtn2.horizontalAlignment = 4;
        this.verifyByBlockButton = this.createRadioButton(container, ID_BLCK, "Verify marked blocks with the selected image file");
        this.verifyByAddressButton = this.createRadioButton(container, ID_ADDR, "Verify by address specifying an image file");
        this.verifyByAddressButton.setSelection(true);
        this.verifyByBlockButton.setLayoutData((Object)dataBtn1);
        this.verifyByAddressButton.setLayoutData((Object)dataBtn2);
    }

    protected Button createRadioButton(Composite parent, int id, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                VerifyOptionsDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        this.setButtonLayoutData(button);
        return button;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.verifyByBlock = this.verifyByBlockButton.getSelection();
        this.verifyByAddress = this.verifyByAddressButton.getSelection();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }
}

