/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.ui.views;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DumpOptionsDialog
extends TitleAreaDialog {
    public boolean dumpByBlock = true;
    public boolean dumpByAddress = false;
    public String strDumpStartAddress = "";
    public String strDumpEndAddress = "";
    private Text textFieldStartAddress;
    private Text textFieldEndAddress;
    private Button dumpByBlockButton;
    private Button dumpByAddressButton;
    static int ID_BLCK = 1100;
    static int ID_ADDR = 1101;

    public DumpOptionsDialog(Shell parent) {
        super(parent);
    }

    public void create() {
        super.create();
        this.setTitle("SPC5 Flash Programmer - Dump Options");
        this.setMessage("Please insert a valid address range", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createRadioBtns(container);
        this.createStartAddress(container);
        this.createEndAddress(container);
        area.pack();
        return area;
    }

    private void createStartAddress(Composite container) {
        GridData dataStartLbl = new GridData();
        dataStartLbl.grabExcessHorizontalSpace = true;
        dataStartLbl.horizontalAlignment = 4;
        Label lbtStartAddr = new Label(container, 0);
        lbtStartAddr.setText("Start address (hex)");
        lbtStartAddr.setLayoutData((Object)dataStartLbl);
        GridData dataStartAddress = new GridData();
        dataStartAddress.grabExcessHorizontalSpace = true;
        dataStartAddress.horizontalAlignment = 4;
        this.textFieldStartAddress = new Text(container, 2048);
        this.textFieldStartAddress.setLayoutData((Object)dataStartAddress);
    }

    private void createEndAddress(Composite container) {
        GridData dataEndLbl = new GridData();
        dataEndLbl.grabExcessHorizontalSpace = true;
        dataEndLbl.horizontalAlignment = 4;
        Label lbtEndAddr = new Label(container, 0);
        lbtEndAddr.setText("End Address (hex)");
        lbtEndAddr.setLayoutData((Object)dataEndLbl);
        GridData dataEndAddress = new GridData();
        dataEndAddress.grabExcessHorizontalSpace = true;
        dataEndAddress.horizontalAlignment = 4;
        this.textFieldEndAddress = new Text(container, 2048);
        this.textFieldEndAddress.setLayoutData((Object)dataEndAddress);
    }

    private void createRadioBtns(Composite container) {
        GridData dataBtn1 = new GridData();
        dataBtn1.grabExcessHorizontalSpace = true;
        dataBtn1.horizontalAlignment = 4;
        GridData dataBtn2 = new GridData();
        dataBtn2.grabExcessHorizontalSpace = true;
        dataBtn2.horizontalAlignment = 4;
        this.dumpByBlockButton = this.createRadioButton(container, ID_BLCK, "Dump by block");
        this.dumpByAddressButton = this.createRadioButton(container, ID_ADDR, "Dump by address");
        this.dumpByAddressButton.setSelection(true);
        this.dumpByBlockButton.setLayoutData((Object)dataBtn1);
        this.dumpByAddressButton.setLayoutData((Object)dataBtn2);
    }

    protected Button createRadioButton(Composite parent, int id, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DumpOptionsDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        this.setButtonLayoutData(button);
        return button;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == ID_BLCK) {
            this.textFieldEndAddress.setEnabled(false);
            this.textFieldStartAddress.setEnabled(false);
        } else if (buttonId == ID_ADDR) {
            this.textFieldEndAddress.setEnabled(true);
            this.textFieldStartAddress.setEnabled(true);
        }
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.strDumpStartAddress = this.textFieldStartAddress.getText();
        if (this.strDumpStartAddress.startsWith("0x") || this.strDumpStartAddress.startsWith("0X")) {
            this.strDumpStartAddress = this.strDumpStartAddress.substring(2);
        }
        this.strDumpEndAddress = this.textFieldEndAddress.getText();
        if (this.strDumpEndAddress.startsWith("0x") || this.strDumpEndAddress.startsWith("0X")) {
            this.strDumpEndAddress = this.strDumpEndAddress.substring(2);
        }
        this.dumpByBlock = this.dumpByBlockButton.getSelection();
        this.dumpByAddress = this.dumpByAddressButton.getSelection();
    }

    protected void okPressed() {
        this.saveInput();
        if (this.inputIsValid()) {
            super.okPressed();
        } else {
            this.displayErrorMessage();
        }
    }

    public int getStartAddress() {
        int retVal = 0;
        if (this.isHex(this.strDumpStartAddress)) {
            retVal = Integer.parseInt(this.strDumpStartAddress, 16);
        }
        return retVal;
    }

    public int getEndAddress() {
        int retVal = 0;
        if (this.isHex(this.strDumpEndAddress)) {
            retVal = Integer.parseInt(this.strDumpEndAddress, 16);
        }
        return retVal;
    }

    private boolean inputIsValid() {
        if (this.getStartAddress() > this.getEndAddress()) {
            this.setMessage("End address is less than start address. Please insert a valid address range.", 3);
            return false;
        }
        return this.dumpByBlock || this.isHex(this.strDumpStartAddress) && this.isHex(this.strDumpEndAddress);
    }

    private boolean isHex(String inputValue) {
        return inputValue.matches("[0-9a-fA-F]+");
    }

    private void displayErrorMessage() {
        if (!this.isHex(this.strDumpStartAddress)) {
            this.setMessage("Please, insert a correct flash dump start address.", 3);
        } else if (!this.isHex(this.strDumpEndAddress)) {
            this.setMessage("Please, insert a correct flash dump end address.", 3);
        }
    }
}

