/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.ui.views;

import com.st.flashtool.drivers.DeviceInfo;
import com.st.flashtool.drivers.FlasherInterfaces;
import com.st.flashtool.drivers.FlasherTargets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class DeviceView
extends ViewPart {
    public static final String ID = "com.st.flashtool.DeviceView";
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Combo interfaceList;
    private Combo deviceList;
    private Combo quartzList;
    private Text textPassword;
    private Button checkAutoBaudrate;
    private Button checkFastComms;
    private Button checkKLine;
    private Button checkASCCAN;
    private Button checkTxAlternateFunction;
    private String[] RAMStartAddressArray = new String[70];
    private String[] RAMSizeArray = new String[70];
    private String[] FlashStartAddressArray = new String[70];
    private String[] FlashEndAddressArray = new String[70];
    private int[] FlashImageStartAddressArray = new int[70];
    private int[] FlashImageEndAddressArray = new int[70];
    private String[] FlashMirroredStartAddressArray = new String[70];
    private String[] FlashMirroredEndAddressArray = new String[70];
    private boolean[] FlashMirroredPresentArray = new boolean[70];
    private String[] FlashSizeArray = new String[70];
    private int[] FlashBlockNum = new int[70];
    private String[] OperationEndAddressArray = new String[70];
    private String[] OperationStartAddressArray = new String[70];
    private String[][] FlashBlockName = new String[70][70];
    private int[] PluginNParametersUART = new int[70];
    private int[] PluginBaseAddressParametersUART = new int[70];
    private int[] PluginNParametersCAN = new int[70];
    private int[] PluginBaseAddressParametersCAN = new int[70];
    private String[][] FlashBlockStartAddressArray = new String[70][70];
    private String[][] FlashBlockEndAddressArray = new String[70][70];
    private String[][] FlashBlockMirroredMaskArray = new String[70][70];
    public int[][] FlashBlockData;
    private Text textFlashStartAddress;
    private Text textFlashEndAddress;
    private Text textFlashMirroredStartAddress;
    private Text textFlashMirroredEndAddress;
    private int MaxInterfaceChannel = 20;
    private int NInterfaceChannels;
    private ConsolePlugin plugin;
    private IConsoleManager consoleManager;
    private IConsole[] existing;
    private MessageConsole console;
    private MessageConsoleStream output;
    private String[] quartzValue = new String[]{"8", "12", "16", "20", "40"};
    private String[] canBaudrate = new String[]{"200", "300", "400", "500", "1000"};
    private String[] uartSPC56Baudrate = new String[]{"9600", "14400", "19200", "24000", "48000"};
    private String[] uartSPC57Baudrate = new String[]{"250000", "250000", "250000", "250000", "250000"};
    private String[] InterfaceChList = new String[20];
    private Table FlashBlockTable;
    private TableColumn tc0;
    public boolean ImageLoaded = false;
    public boolean isConnected = false;
    private Button buttonConnect = null;
    private Button buttonDisconnect = null;
    private Button buttonLoadImage = null;
    private Button buttonProgram = null;
    private Button buttonErase = null;
    private Button buttonDump = null;
    private Button buttonVerify = null;
    private Button buttonBlankCheck = null;
    private Text textImageFileName;

    public void PrintSPC5FlasherConsole(String stringMessage) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss]: ");
        Date date = new Date();
        String str = dateFormat.format(date);
        str = String.valueOf(str) + stringMessage;
        this.output.println(str);
    }

    public void DeseclectAllBlocks() {
        int m = 0;
        while (m < this.FlashBlockTable.getItemCount()) {
            this.FlashBlockTable.getItems()[m].setChecked(false);
            this.tc0.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/unchecked.jpg"));
            this.FlashBlockTable.deselectAll();
            ++m;
        }
    }

    public void SetImageLoadedFlag(boolean bVal) {
        this.ImageLoaded = bVal;
    }

    public boolean GetImageLoadedFlag() {
        return this.ImageLoaded;
    }

    public int GetPluginNParametersUART() {
        return this.PluginNParametersUART[this.deviceList.getSelectionIndex()];
    }

    public int GetPluginBaseAddressParametersUART() {
        return this.PluginBaseAddressParametersUART[this.deviceList.getSelectionIndex()];
    }

    public int GetPluginNParametersCAN() {
        return this.PluginNParametersCAN[this.deviceList.getSelectionIndex()];
    }

    public int GetPluginBaseAddressParametersCAN() {
        return this.PluginBaseAddressParametersCAN[this.deviceList.getSelectionIndex()];
    }

    public void EnableProgramCommand(boolean bVal) {
        this.buttonProgram.setEnabled(bVal);
    }

    public void SetImageFileName(String strImageFileName) {
        this.textImageFileName.setText(strImageFileName);
    }

    public void InitFlashBlockMapArray() {
        int FlashBlockSize = 0;
        int FlashBlock = this.FlashBlockNum[this.deviceList.getSelectionIndex()];
        this.FlashBlockData = new int[FlashBlock][];
        int DvIndex = this.deviceList.getSelectionIndex();
        int i = 0;
        while (i < this.FlashBlockNum[DvIndex]) {
            FlashBlockSize = Integer.parseInt(this.FlashBlockEndAddressArray[DvIndex][i], 16) - Integer.parseInt(this.FlashBlockStartAddressArray[DvIndex][i], 16) + 1;
            this.FlashBlockData[i] = new int[FlashBlockSize];
            int j = 0;
            while (j < FlashBlockSize) {
                this.FlashBlockData[i][j] = 255;
                ++j;
            }
            ++i;
        }
    }

    public void SetImageStartAddress(int nBlock, int data) {
        this.FlashImageStartAddressArray[nBlock] = data;
    }

    public void SetImageEndAddress(int nBlock, int data) {
        this.FlashImageEndAddressArray[nBlock] = data;
    }

    public int GetImageStartAddress(int nBlock) {
        return this.FlashImageStartAddressArray[nBlock];
    }

    public int GetImageEndAddress(int nBlock) {
        return this.FlashImageEndAddressArray[nBlock];
    }

    public void LoadFlashBlockData(int nBlock, int byteCount, int data) {
        this.FlashBlockData[nBlock][byteCount] = data;
    }

    public int GetFlashBlockData(int nBlock, int byteCount) {
        return this.FlashBlockData[nBlock][byteCount];
    }

    public String getInterface() {
        return this.interfaceList.getText();
    }

    public String getTargetDevice() {
        return this.deviceList.getText();
    }

    public String getPassword() {
        return this.textPassword.getText();
    }

    public String getExternalQuartz() {
        return this.quartzList.getText();
    }

    public int getInterfaceChannel() {
        return this.interfaceList.getSelectionIndex();
    }

    public void setInterfaceChannel(int count) {
        if (count < this.MaxInterfaceChannel) {
            this.NInterfaceChannels = count;
        }
    }

    public void setInterfaceChList(String[] List2) {
        int i = 0;
        while (i < this.NInterfaceChannels) {
            this.InterfaceChList[i] = List2[i];
            ++i;
        }
    }

    public int getRAMStartAddress() {
        return Integer.parseInt(this.RAMStartAddressArray[this.deviceList.getSelectionIndex()], 16);
    }

    public int getRAMSize() {
        return Integer.parseInt(this.RAMSizeArray[this.deviceList.getSelectionIndex()], 16);
    }

    public int getFlashStartAddress() {
        return Integer.parseInt(this.FlashStartAddressArray[this.deviceList.getSelectionIndex()], 16);
    }

    public int getFlashEndAddress() {
        return Integer.parseInt(this.FlashEndAddressArray[this.deviceList.getSelectionIndex()], 16);
    }

    public int getFlashMirroredStartAddress() {
        if (this.FlashMirroredPresentArray[this.deviceList.getSelectionIndex()]) {
            return Integer.parseInt(this.FlashMirroredStartAddressArray[this.deviceList.getSelectionIndex()], 16);
        }
        return 0;
    }

    public int getFlashMirroredEndAddress() {
        if (this.FlashMirroredPresentArray[this.deviceList.getSelectionIndex()]) {
            return Integer.parseInt(this.FlashMirroredEndAddressArray[this.deviceList.getSelectionIndex()], 16);
        }
        return 0;
    }

    public boolean isFlashMirroredPresent() {
        return this.FlashMirroredPresentArray[this.deviceList.getSelectionIndex()];
    }

    public int getFlashBlockNumber() {
        return this.FlashBlockNum[this.deviceList.getSelectionIndex()];
    }

    public int getFlashBlockMirroredMask(int nBlock) {
        return Integer.parseInt(this.FlashBlockMirroredMaskArray[this.deviceList.getSelectionIndex()][nBlock], 16);
    }

    public int getFlashBlockStartAddress(int nBlock) {
        return Integer.parseInt(this.FlashBlockStartAddressArray[this.deviceList.getSelectionIndex()][nBlock], 16);
    }

    public int getFlashBlockEndAddress(int nBlock) {
        return Integer.parseInt(this.FlashBlockEndAddressArray[this.deviceList.getSelectionIndex()][nBlock], 16);
    }

    public void SelectFlashBlock(int nBlock, boolean selection) {
        this.FlashBlockTable.getItems()[nBlock].setChecked(selection);
    }

    public boolean getFlashBlockSelection(int nBlock) {
        return this.FlashBlockTable.getItems()[nBlock].getChecked();
    }

    public int getOperationStartAddress() {
        return Integer.parseInt(this.OperationStartAddressArray[this.deviceList.getSelectionIndex()], 16);
    }

    public int getOperationEndAddress() {
        return Integer.parseInt(this.OperationEndAddressArray[this.deviceList.getSelectionIndex()], 16);
    }

    public void setFlashStartAddress(String strFlashsize) {
        this.textFlashStartAddress.setText(strFlashsize);
    }

    public void setFlashEndAddress(String strFlashsize) {
        this.textFlashEndAddress.setText(strFlashsize);
    }

    public Boolean getAutoBaudrate() {
        return this.checkAutoBaudrate.getSelection();
    }

    public Boolean getTxFast() {
        return this.checkFastComms.getSelection();
    }

    public Boolean getAlternateTx() {
        return this.checkTxAlternateFunction.getSelection();
    }

    public Boolean getKLine() {
        return this.checkKLine.getSelection();
    }

    public Boolean getASCCAN() {
        return this.checkASCCAN.getSelection();
    }

    public String getCanBaudrate(String quartz) {
        if (quartz != null) {
            int i = 0;
            while (i < this.quartzValue.length) {
                if (this.quartzValue[i].compareTo(quartz) == 0) {
                    return this.canBaudrate[i];
                }
                ++i;
            }
        }
        return "0";
    }

    public String getUartSPC56Baudrate(String quartz) {
        if (quartz != null) {
            int i = 0;
            while (i < this.quartzValue.length) {
                if (this.quartzValue[i].compareTo(quartz) == 0) {
                    return this.uartSPC56Baudrate[i];
                }
                ++i;
            }
        }
        return "9600";
    }

    public String getUartSPC57Baudrate(String quartz) {
        if (quartz != null) {
            int i = 0;
            while (i < this.quartzValue.length) {
                if (this.quartzValue[i].compareTo(quartz) == 0) {
                    return this.uartSPC57Baudrate[i];
                }
                ++i;
            }
        }
        return "250000";
    }

    public void AllEnabled() {
        boolean Connected = true;
        this.buttonConnect.setEnabled(Connected);
        this.buttonDisconnect.setEnabled(Connected);
        this.buttonLoadImage.setEnabled(Connected);
        this.buttonProgram.setEnabled(false);
        this.buttonErase.setEnabled(Connected);
        this.buttonDump.setEnabled(Connected);
        this.buttonVerify.setEnabled(Connected);
        this.buttonBlankCheck.setEnabled(Connected);
        this.interfaceList.setEnabled(Connected);
        this.deviceList.setEnabled(Connected);
        this.quartzList.setEnabled(Connected);
        this.textPassword.setEnabled(Connected);
        this.checkAutoBaudrate.setEnabled(Connected);
        this.checkFastComms.setEnabled(Connected);
        this.checkTxAlternateFunction.setEnabled(Connected);
        this.checkKLine.setEnabled(Connected);
        this.checkASCCAN.setEnabled(Connected);
    }

    public void updateUI(boolean Connected) {
        this.buttonConnect.setEnabled(!Connected);
        this.buttonDisconnect.setEnabled(Connected);
        this.buttonProgram.setEnabled(false);
        this.buttonLoadImage.setEnabled(Connected);
        this.buttonErase.setEnabled(Connected);
        this.buttonDump.setEnabled(Connected);
        this.buttonVerify.setEnabled(Connected);
        this.buttonBlankCheck.setEnabled(Connected);
        this.interfaceList.setEnabled(!Connected);
        this.deviceList.setEnabled(!Connected);
        this.quartzList.setEnabled(!Connected);
        this.textPassword.setEnabled(!Connected);
        this.checkAutoBaudrate.setEnabled(!Connected);
        this.checkFastComms.setEnabled(!Connected);
        this.checkTxAlternateFunction.setEnabled(!Connected);
        this.checkKLine.setEnabled(!Connected);
        this.checkASCCAN.setEnabled(!Connected);
    }

    public void showBusy(boolean busy) {
        System.out.println("Here");
        super.showBusy(busy);
        if (busy) {
            this.setPartName("busy...");
        } else {
            this.setPartName("Sample View");
        }
    }

    public void createPartControl(Composite parent) {
        this.plugin = ConsolePlugin.getDefault();
        this.consoleManager = this.plugin.getConsoleManager();
        this.existing = this.consoleManager.getConsoles();
        this.console = null;
        int i = 0;
        while (i < this.existing.length) {
            if ("SPC5 Flash Programmer".equals(this.existing[i].getName())) {
                this.console = (MessageConsole)this.existing[i];
                break;
            }
            ++i;
        }
        if (this.console == null) {
            this.console = new MessageConsole("SPC5 Flash Tool", null);
            this.consoleManager.addConsoles(new IConsole[]{this.console});
        }
        this.output = this.console.newMessageStream();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.getBody().setBackground(SWTResourceManager.getColor(1));
        this.form.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 12, 1));
        this.form.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/SFP_Banner.png"));
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.form.getBody().setLayoutData((Object)new TableWrapData(128));
        this.form.getBody().setLayout(null);
        Section sectionDeviceConfig = this.toolkit.createSection(this.form.getBody(), 322);
        sectionDeviceConfig.setToolTipText("");
        sectionDeviceConfig.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        sectionDeviceConfig.setBounds(10, 10, 352, 447);
        sectionDeviceConfig.setText("Configuration");
        sectionDeviceConfig.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                DeviceView.this.form.reflow(true);
            }
        });
        Composite sectionClientDeviceConfig = this.toolkit.createComposite((Composite)sectionDeviceConfig);
        sectionClientDeviceConfig.setBackground(SWTResourceManager.getColor(1));
        sectionClientDeviceConfig.setLayoutData((Object)new TableWrapData(128));
        sectionClientDeviceConfig.setLayout(null);
        Label label = this.toolkit.createLabel(sectionClientDeviceConfig, "Device:");
        label.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        label.setBounds(0, 26, 48, 15);
        this.deviceList = new Combo(sectionClientDeviceConfig, 0x80000C);
        this.deviceList.setToolTipText("Select the device");
        this.deviceList.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.deviceList.setBounds(54, 23, 113, 24);
        this.deviceList.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        FlasherTargets targets = new FlasherTargets();
        List deviceListArray = targets.getDevicesList();
        Iterator iterator = deviceListArray.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            DeviceInfo device = (DeviceInfo)iterator.next();
            this.deviceList.add(device.name);
            this.FlashStartAddressArray[n] = device.flashStartAddress.substring(2);
            this.FlashEndAddressArray[n] = device.flashEndAddress.substring(2);
            if (device.flashMirroredPresent) {
                this.FlashMirroredStartAddressArray[n] = device.flashMirroredStartAddress.substring(2);
                this.FlashMirroredEndAddressArray[n] = device.flashMirroredEndAddress.substring(2);
                this.FlashMirroredPresentArray[n] = device.flashMirroredPresent;
            } else {
                this.FlashMirroredStartAddressArray[n] = "N.A.";
                this.FlashMirroredEndAddressArray[n] = "N.A.";
                this.FlashMirroredPresentArray[n] = device.flashMirroredPresent;
            }
            this.FlashSizeArray[n] = device.flashSize.substring(2);
            this.RAMStartAddressArray[n] = device.RAMStartAddress.substring(2);
            this.RAMSizeArray[n] = device.RAMSize.substring(2);
            this.FlashBlockNum[n] = device.flashNumBlocks;
            this.PluginNParametersUART[n] = device.nParametersUART;
            this.PluginBaseAddressParametersUART[n] = device.ParametersBaseAddressUART;
            this.PluginNParametersCAN[n] = device.nParametersCAN;
            this.PluginBaseAddressParametersCAN[n] = device.ParametersBaseAddressCAN;
            int i2 = 0;
            while (i2 < this.FlashBlockNum[n]) {
                this.FlashBlockName[n][i2] = device.BlockName[i2];
                this.FlashBlockStartAddressArray[n][i2] = device.BlockStartAddress[i2].substring(2);
                this.FlashBlockEndAddressArray[n][i2] = device.BlockEndAddress[i2].substring(2);
                this.FlashBlockMirroredMaskArray[n][i2] = device.BlockMirroredMask[i2].substring(2);
                ++i2;
            }
            ++n;
        }
        this.deviceList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeviceView.this.ImageLoaded = false;
                DeviceView.this.buttonProgram.setEnabled(false);
                if (DeviceView.this.isConnected) {
                    boolean bl = MessageDialog.open((int)3, (Shell)DeviceView.this.form.getShell(), (String)"SPC5 Flash Tool", (String)"This operation will disconnect current target. Do you want to continue?", (int)0x100000C0);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deviceList.select(0);
        Label label_1 = this.toolkit.createLabel(sectionClientDeviceConfig, "Quartz (MHz):");
        label_1.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        label_1.setBounds(180, 26, 80, 15);
        this.quartzList = new Combo(sectionClientDeviceConfig, 8);
        this.quartzList.setToolTipText("Select the external clock (MHz)");
        this.quartzList.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.quartzList.setBounds(266, 23, 43, 24);
        this.quartzList.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.quartzList.setItems(this.quartzValue);
        this.quartzList.select(0);
        Label label_2 = this.toolkit.createLabel(sectionClientDeviceConfig, "Password:");
        label_2.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        label_2.setBounds(54, 70, 60, 15);
        this.textPassword = this.toolkit.createText(sectionClientDeviceConfig, "0xFEEDFACECAFEBEEF", 0x1000000);
        this.textPassword.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.textPassword.setBounds(120, 67, 150, 21);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.checkAutoBaudrate = this.toolkit.createButton(sectionClientDeviceConfig, "Auto baudrate", 32);
        this.checkAutoBaudrate.setToolTipText("Enable auto baudrate function");
        this.checkAutoBaudrate.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.checkAutoBaudrate.setBounds(153, 102, 100, 16);
        this.checkFastComms = this.toolkit.createButton(sectionClientDeviceConfig, "Fast", 32);
        this.checkFastComms.setToolTipText("Enable fast speed comunication after connection");
        this.checkFastComms.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.checkFastComms.setBounds(54, 124, 43, 16);
        this.checkASCCAN = this.toolkit.createButton(sectionClientDeviceConfig, "ASC@CAN", 32);
        this.checkASCCAN.setToolTipText("Enable ASC@CAN function");
        this.checkASCCAN.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.checkASCCAN.setBounds(54, 102, 80, 16);
        this.checkKLine = this.toolkit.createButton(sectionClientDeviceConfig, "K-Line", 32);
        this.checkKLine.setToolTipText("Enable k-Line communication");
        this.checkKLine.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.checkKLine.setBounds(54, 146, 60, 16);
        sectionDeviceConfig.setClient((Control)sectionClientDeviceConfig);
        this.checkTxAlternateFunction = this.toolkit.createButton(sectionClientDeviceConfig, "Use Tx alternate function", 32);
        this.checkTxAlternateFunction.setToolTipText("Enable tx alternate function");
        this.checkTxAlternateFunction.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.checkTxAlternateFunction.setBounds(153, 124, 156, 16);
        final Label lblStartAddress_1 = this.toolkit.createLabel(sectionClientDeviceConfig, "Flash start address (No overlay allowed):");
        lblStartAddress_1.setAlignment(131072);
        lblStartAddress_1.setBounds(0, 174, 236, 21);
        lblStartAddress_1.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        final Label lblEndAddress_1 = this.toolkit.createLabel(sectionClientDeviceConfig, "Flash end address (No overlay allowed):");
        lblEndAddress_1.setAlignment(131072);
        lblEndAddress_1.setBounds(0, 200, 236, 21);
        lblEndAddress_1.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.textFlashStartAddress = this.toolkit.createText(sectionClientDeviceConfig, "0", 0x1000008);
        this.textFlashStartAddress.setBackground(SWTResourceManager.getColor(19));
        this.textFlashStartAddress.setBounds(242, 174, 73, 21);
        this.textFlashStartAddress.setToolTipText("<Start address> Target flash start address. ");
        this.textFlashStartAddress.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.textFlashEndAddress = this.toolkit.createText(sectionClientDeviceConfig, "3FFF", 0x1000008);
        this.textFlashEndAddress.setBackground(SWTResourceManager.getColor(19));
        this.textFlashEndAddress.setBounds(242, 200, 73, 21);
        this.textFlashEndAddress.setToolTipText("<End address> Target flash end address. ");
        this.textFlashEndAddress.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        final Label lblFlashStartAddress = this.toolkit.createLabel(sectionClientDeviceConfig, "Flash start address (overlay allowed):");
        lblFlashStartAddress.setAlignment(131072);
        lblFlashStartAddress.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        lblFlashStartAddress.setBounds(0, 227, 236, 21);
        final Label lblFlashEndAddress = this.toolkit.createLabel(sectionClientDeviceConfig, "Flash end address (overlay allowed):");
        lblFlashEndAddress.setAlignment(131072);
        lblFlashEndAddress.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        lblFlashEndAddress.setBounds(0, 254, 236, 21);
        this.textFlashMirroredStartAddress = this.toolkit.createText(sectionClientDeviceConfig, "0", 0x1000008);
        this.textFlashMirroredStartAddress.setToolTipText("<Start address> Target flash mirrored start address. ");
        this.textFlashMirroredStartAddress.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.textFlashMirroredStartAddress.setBackground(SWTResourceManager.getColor(19));
        this.textFlashMirroredStartAddress.setBounds(242, 227, 73, 21);
        this.textFlashMirroredEndAddress = this.toolkit.createText(sectionClientDeviceConfig, "3FFF", 0x1000008);
        this.textFlashMirroredEndAddress.setToolTipText("<End address> Target flash end address. ");
        this.textFlashMirroredEndAddress.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.textFlashMirroredEndAddress.setBackground(SWTResourceManager.getColor(19));
        this.textFlashMirroredEndAddress.setBounds(242, 254, 73, 21);
        final Label label_8 = new Label(sectionClientDeviceConfig, 258);
        label_8.setBounds(0, 290, 335, 12);
        this.toolkit.adapt((Control)label_8, true, true);
        this.textFlashStartAddress.setText(this.FlashStartAddressArray[0]);
        this.textFlashEndAddress.setText(this.FlashEndAddressArray[0]);
        if (this.FlashMirroredPresentArray[0]) {
            lblFlashStartAddress.setVisible(true);
            lblFlashEndAddress.setVisible(true);
            lblStartAddress_1.setText("Flash start address (No overlay allowed):");
            lblEndAddress_1.setText("Flash end address (No overlay allowed):");
            lblStartAddress_1.setBounds(0, 174, 236, 21);
            this.textFlashStartAddress.setBounds(242, 174, 73, 21);
            lblEndAddress_1.setBounds(0, 200, 236, 21);
            this.textFlashEndAddress.setBounds(242, 200, 73, 21);
            label_8.setBounds(0, 290, 335, 12);
            this.textFlashMirroredStartAddress.setVisible(true);
            this.textFlashMirroredEndAddress.setVisible(true);
            this.textFlashMirroredStartAddress.setText(this.FlashMirroredStartAddressArray[0]);
            this.textFlashMirroredEndAddress.setText(this.FlashMirroredEndAddressArray[0]);
        } else {
            lblFlashStartAddress.setVisible(false);
            lblFlashEndAddress.setVisible(false);
            lblStartAddress_1.setText("Flash start address:");
            lblEndAddress_1.setText("Flash end address:");
            lblStartAddress_1.setBounds(0, 174, 160, 21);
            this.textFlashStartAddress.setBounds(166, 174, 73, 21);
            lblEndAddress_1.setBounds(0, 200, 160, 21);
            label_8.setBounds(0, 255, 335, 12);
            this.textFlashEndAddress.setBounds(166, 200, 73, 21);
            this.textFlashMirroredStartAddress.setVisible(false);
            this.textFlashMirroredEndAddress.setVisible(false);
            this.textFlashMirroredStartAddress.setText("N.A.");
            this.textFlashMirroredEndAddress.setText("N.A.");
        }
        Label label_10 = new Label(sectionClientDeviceConfig, 258);
        label_10.setBounds(0, 234, 249, -1);
        this.toolkit.adapt((Control)label_10, true, true);
        Label label_5 = this.toolkit.createLabel(sectionClientDeviceConfig, "Interface:");
        label_5.setBounds(0, 315, 50, 15);
        label_5.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.interfaceList = new Combo(sectionClientDeviceConfig, 8);
        this.interfaceList.setBounds(54, 312, 255, 24);
        this.interfaceList.setToolTipText("Specify the interface ");
        this.interfaceList.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.interfaceList.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.interfaceList.setItems(FlasherInterfaces.getInterfacesArray());
        this.interfaceList.select(0);
        this.interfaceList.addListener(3, new Listener(){

            public void handleEvent(Event arg0) {
                Cursor waitCursor = Display.getDefault().getSystemCursor(1);
                Display.getDefault().getActiveShell().setCursor(waitCursor);
                try {
                    int NumItem = DeviceView.this.interfaceList.getItemCount();
                    DeviceView.this.interfaceList.setItems(FlasherInterfaces.getInterfacesArray());
                    if (NumItem != DeviceView.this.interfaceList.getItemCount()) {
                        DeviceView.this.interfaceList.setVisibleItemCount(DeviceView.this.interfaceList.getItemCount());
                        DeviceView.this.interfaceList.setListVisible(true);
                    }
                    DeviceView.this.interfaceList.select(0);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getLocalizedMessage());
                }
                Display.getDefault().getActiveShell().setCursor(null);
            }
        });
        this.buttonDisconnect = this.toolkit.createButton(sectionClientDeviceConfig, " Disconnect", 0x800008);
        this.buttonDisconnect.setToolTipText("Disconnect the communication");
        this.buttonDisconnect.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/disconnect-icon.png"));
        this.buttonDisconnect.setBounds(181, 363, 128, 38);
        this.buttonDisconnect.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonConnect = this.toolkit.createButton(sectionClientDeviceConfig, " Connect", 0x800008);
        this.buttonConnect.setToolTipText("Pusch Connect button to connect the device selected using the interface");
        this.buttonConnect.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/connect-icon.png"));
        this.buttonConnect.setBounds(54, 363, 128, 38);
        this.buttonConnect.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.ConnectCommand", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getLocalizedMessage());
                }
            }
        });
        this.buttonDisconnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.DisconnectCommand", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getLocalizedMessage());
                }
            }
        });
        Section sectionCommands = this.toolkit.createSection(this.form.getBody(), 320);
        sectionCommands.setBounds(368, 10, 622, 489);
        sectionCommands.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        sectionCommands.setText("Operations");
        Composite sectionClientCommands = this.toolkit.createComposite((Composite)sectionCommands);
        sectionCommands.setClient((Control)sectionClientCommands);
        sectionClientCommands.setLayoutData((Object)new GridData(768));
        sectionClientCommands.setLayout(null);
        this.buttonProgram = this.toolkit.createButton(sectionClientCommands, " Program", 0x800008);
        this.buttonProgram.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/program-icon.png"));
        this.buttonProgram.setToolTipText("Program command");
        this.buttonProgram.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonProgram.setBounds(452, 155, 126, 33);
        this.buttonProgram.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.ProgramCommand", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("DeviceView: command with id com.st.flashtool.commands.ProgramCommand not found");
                }
            }
        });
        this.buttonErase = this.toolkit.createButton(sectionClientCommands, " Erase", 0x800008);
        this.buttonErase.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/erase-icon.png"));
        this.buttonErase.setToolTipText("Erase command");
        this.buttonErase.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonErase.setBounds(452, 116, 126, 33);
        this.buttonErase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.EraseCommand", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("DeviceView: command with id com.st.flashtool.commands.EraseCommand not found");
                }
            }
        });
        this.buttonDump = this.toolkit.createButton(sectionClientCommands, " Dump", 0x800008);
        this.buttonDump.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/dump-icon.png"));
        this.buttonDump.setToolTipText("Dump command");
        this.buttonDump.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonDump.setBounds(452, 194, 126, 33);
        this.buttonDump.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.DumpCommand", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("DeviceView: command with id com.st.flashtool.commands.DumpCommand not found");
                }
            }
        });
        this.buttonBlankCheck = this.toolkit.createButton(sectionClientCommands, " Blank check", 0x800008);
        this.buttonBlankCheck.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/blankcheck-icon.png"));
        this.buttonBlankCheck.setToolTipText("Blank check command");
        this.buttonBlankCheck.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonBlankCheck.setBounds(452, 273, 126, 33);
        this.buttonBlankCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.BlankCheckCommand", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("DeviceView: command with id com.st.flashtool.commands.BlankCheckCommand not found");
                }
            }
        });
        this.buttonVerify = this.toolkit.createButton(sectionClientCommands, " Verify", 0x800008);
        this.buttonVerify.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/verify-icon.png"));
        this.buttonVerify.setToolTipText("Verify command");
        this.buttonVerify.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonVerify.setBounds(452, 234, 126, 33);
        this.buttonVerify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.VerifyCommand", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("DeviceView: command with id com.st.flashtool.commands.VerifyCommand not found");
                }
            }
        });
        Section section = this.toolkit.createSection(sectionClientCommands, 322);
        section.setToolTipText("");
        section.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        section.setBounds(0, -132, 279, 99);
        this.toolkit.paintBordersFor((Composite)section);
        section.setText("Device configuration");
        this.FlashBlockTable = new Table(sectionClientCommands, 2592);
        this.FlashBlockTable.setBounds(0, 48, 399, 351);
        this.toolkit.adapt((Composite)this.FlashBlockTable);
        this.toolkit.paintBordersFor((Composite)this.FlashBlockTable);
        this.tc0 = new TableColumn(this.FlashBlockTable, 0x1000000);
        this.tc0.setToolTipText("Select all");
        this.tc0.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/unchecked.jpg"));
        this.tc0.setWidth(32);
        TableColumn tc1 = new TableColumn(this.FlashBlockTable, 0x1000000);
        tc1.setText("Flash Block Name");
        tc1.setWidth(152);
        TableColumn tc2 = new TableColumn(this.FlashBlockTable, 0x1000000);
        tc2.setText("Start Address");
        tc2.setWidth(97);
        TableColumn tc3 = new TableColumn(this.FlashBlockTable, 0x1000000);
        tc3.setText("End Address");
        tc3.setWidth(97);
        this.FlashBlockTable.setHeaderVisible(true);
        this.FlashBlockTable.setLinesVisible(true);
        Label lblImage = this.toolkit.createLabel(sectionClientCommands, "Image:");
        lblImage.setBounds(0, 13, 38, 15);
        lblImage.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.buttonLoadImage = new Button(sectionClientCommands, 0);
        this.buttonLoadImage.setBounds(374, 8, 25, 25);
        this.buttonLoadImage.setToolTipText("Select image file name");
        this.buttonLoadImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)DeviceView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.st.flashtool.commands.LoadImageCommand", null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("DeviceView: command with id com.st.flashtool.commands.LoadImageCommand not found");
                }
            }
        });
        this.buttonLoadImage.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 14, 1));
        this.toolkit.adapt((Control)this.buttonLoadImage, true, true);
        this.buttonLoadImage.setText("...");
        this.textImageFileName = new Text(sectionClientCommands, 2048);
        this.textImageFileName.setEditable(false);
        this.textImageFileName.setBounds(43, 10, 330, 21);
        this.textImageFileName.setToolTipText("Image file name");
        this.textImageFileName.setFont(SWTResourceManager.getFont("@Arial Unicode MS", 9, 0));
        this.toolkit.adapt((Control)this.textImageFileName, true, true);
        this.tc0.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int m;
                boolean checkBoxFlag = false;
                int i = 0;
                while (i < DeviceView.this.FlashBlockTable.getItemCount()) {
                    if (DeviceView.this.FlashBlockTable.getItems()[i].getChecked()) {
                        checkBoxFlag = true;
                    }
                    ++i;
                }
                if (checkBoxFlag) {
                    m = 0;
                    while (m < DeviceView.this.FlashBlockTable.getItemCount()) {
                        DeviceView.this.FlashBlockTable.getItems()[m].setChecked(false);
                        DeviceView.this.tc0.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/unchecked.jpg"));
                        DeviceView.this.FlashBlockTable.deselectAll();
                        ++m;
                    }
                } else {
                    m = 0;
                    while (m < DeviceView.this.FlashBlockTable.getItemCount()) {
                        DeviceView.this.FlashBlockTable.getItems()[m].setChecked(true);
                        DeviceView.this.tc0.setImage(ResourceManager.getPluginImage("com.st.flashtool.ui.views", "icons/checked.jpg"));
                        DeviceView.this.FlashBlockTable.selectAll();
                        ++m;
                    }
                }
            }
        });
        sectionCommands.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                DeviceView.this.form.reflow(true);
            }
        });
        int loopIndex = 0;
        while (loopIndex < this.FlashBlockNum[0]) {
            TableItem item = new TableItem(this.FlashBlockTable, 0);
            item.setText(1, this.FlashBlockName[0][loopIndex]);
            item.setText(2, this.FlashBlockStartAddressArray[0][loopIndex]);
            item.setText(3, this.FlashBlockEndAddressArray[0][loopIndex]);
            ++loopIndex;
        }
        this.deviceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeviceView.this.deviceList.getText().contains("SPC57") || DeviceView.this.deviceList.getText().contains("SPC58")) {
                    DeviceView.this.checkAutoBaudrate.setEnabled(false);
                    DeviceView.this.checkFastComms.setEnabled(true);
                    DeviceView.this.checkKLine.setEnabled(false);
                    DeviceView.this.checkASCCAN.setEnabled(true);
                    DeviceView.this.checkTxAlternateFunction.setEnabled(false);
                } else {
                    DeviceView.this.checkAutoBaudrate.setEnabled(true);
                    DeviceView.this.checkFastComms.setEnabled(true);
                    DeviceView.this.checkKLine.setEnabled(true);
                    DeviceView.this.checkASCCAN.setEnabled(true);
                    DeviceView.this.checkTxAlternateFunction.setEnabled(true);
                }
                DeviceView.this.textFlashStartAddress.setText(DeviceView.this.FlashStartAddressArray[DeviceView.this.deviceList.getSelectionIndex()]);
                DeviceView.this.textFlashEndAddress.setText(DeviceView.this.FlashEndAddressArray[DeviceView.this.deviceList.getSelectionIndex()]);
                if (DeviceView.this.FlashMirroredPresentArray[DeviceView.this.deviceList.getSelectionIndex()]) {
                    lblFlashStartAddress.setVisible(true);
                    lblFlashEndAddress.setVisible(true);
                    DeviceView.this.textFlashMirroredStartAddress.setVisible(true);
                    DeviceView.this.textFlashMirroredEndAddress.setVisible(true);
                    lblStartAddress_1.setText("Flash start address (No overlay allowed):");
                    lblEndAddress_1.setText("Flash end address (No overlay allowed):");
                    lblStartAddress_1.setBounds(0, 174, 236, 21);
                    DeviceView.this.textFlashStartAddress.setBounds(242, 174, 73, 21);
                    lblEndAddress_1.setBounds(0, 200, 236, 21);
                    DeviceView.this.textFlashEndAddress.setBounds(242, 200, 73, 21);
                    label_8.setBounds(0, 290, 335, 12);
                    DeviceView.this.textFlashMirroredStartAddress.setText(DeviceView.this.FlashMirroredStartAddressArray[DeviceView.this.deviceList.getSelectionIndex()]);
                    DeviceView.this.textFlashMirroredEndAddress.setText(DeviceView.this.FlashMirroredEndAddressArray[DeviceView.this.deviceList.getSelectionIndex()]);
                } else {
                    lblFlashStartAddress.setVisible(false);
                    lblFlashEndAddress.setVisible(false);
                    lblStartAddress_1.setText("Flash start address:");
                    lblEndAddress_1.setText("Flash end address:");
                    lblStartAddress_1.setBounds(0, 174, 160, 21);
                    DeviceView.this.textFlashStartAddress.setBounds(166, 174, 73, 21);
                    lblEndAddress_1.setBounds(0, 200, 160, 21);
                    DeviceView.this.textFlashEndAddress.setBounds(166, 200, 73, 21);
                    label_8.setBounds(0, 255, 335, 12);
                    DeviceView.this.textFlashMirroredStartAddress.setVisible(false);
                    DeviceView.this.textFlashMirroredEndAddress.setVisible(false);
                    DeviceView.this.textFlashMirroredStartAddress.setText("N.A.");
                    DeviceView.this.textFlashMirroredEndAddress.setText("N.A.");
                }
                DeviceView.this.FlashBlockTable.clearAll();
                DeviceView.this.FlashBlockTable.setItemCount(0);
                int loopIndex = 0;
                while (loopIndex < DeviceView.this.FlashBlockNum[DeviceView.this.deviceList.getSelectionIndex()]) {
                    TableItem item = new TableItem(DeviceView.this.FlashBlockTable, 0);
                    item.setText(1, DeviceView.this.FlashBlockName[DeviceView.this.deviceList.getSelectionIndex()][loopIndex]);
                    item.setText(2, DeviceView.this.FlashBlockStartAddressArray[DeviceView.this.deviceList.getSelectionIndex()][loopIndex]);
                    item.setText(3, DeviceView.this.FlashBlockEndAddressArray[DeviceView.this.deviceList.getSelectionIndex()][loopIndex]);
                    ++loopIndex;
                }
            }
        });
        this.form.setMinSize(new Point(0, 0));
        this.updateUI(this.isConnected);
    }

    public void setFocus() {
        this.form.setFocus();
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Object[]) {
                return (Object[])parent;
            }
            return new Object[0];
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

