/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.handlers;

import com.st.flashtool.drivers.ConnectionInfo;
import com.st.flashtool.drivers.ErrorsDescription;
import com.st.flashtool.drivers.SPCFlasherConnectDll;
import com.st.flashtool.handlers.Messages;
import com.st.flashtool.ui.views.DeviceView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class EraseHandler
extends AbstractHandler {
    private static ConnectionInfo ci;
    private static SPCFlasherConnectDll.ProgressCallback progressCallback;
    private static SPCFlasherConnectDll.EventCallback eventCallback;
    DeviceView dv;
    ErrorsDescription ed;
    int nRC;
    IProgressMonitor localMonitor;
    int step = 0;
    int nBlockCount = 0;
    int FlashBlockNum = 0;
    String stringMessage = "";
    int[] bFlashBlockStartAddress;
    int[] bFlashBlockEndAddress;
    int[] bFlashBlockSize;
    int[] bFlashBlockMirroredMask;
    boolean[] bFlashSelected;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.ed = new ErrorsDescription();
        this.step = 0;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.dv = (DeviceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.dv.PrintSPC5FlasherConsole(Messages.EraseHandler_EraseStart);
        progressCallback = new SPCFlasherConnectDll.ProgressCallback(){

            public void invoke(int total, int current) {
                int n = EraseHandler.this.step;
                while (n <= (EraseHandler.this.nBlockCount + 1) * current / EraseHandler.this.FlashBlockNum) {
                    EraseHandler.this.localMonitor.worked(1);
                    ++n;
                    ++n;
                }
                EraseHandler.this.step = n;
            }
        };
        eventCallback = new SPCFlasherConnectDll.EventCallback(){

            public void invoke(int event, int value) {
                if (event == 0) {
                    // empty if block
                }
            }
        };
        window.getShell().setCursor(new Cursor((Device)window.getShell().getDisplay(), 1));
        ci = new ConnectionInfo();
        EraseHandler.ci.cbSize = ci.size();
        EraseHandler.ci.uiChannel = this.dv.getInterfaceChannel();
        EraseHandler.ci.strInterface = this.dv.getInterface();
        EraseHandler.ci.strDevice = this.dv.getTargetDevice();
        EraseHandler.ci.FlashStartAddress = this.dv.getFlashStartAddress();
        EraseHandler.ci.FlashEndAddress = this.dv.getFlashEndAddress();
        EraseHandler.ci.bConnected = 1;
        EraseHandler.ci.hProgramThread = null;
        EraseHandler.ci.hProgramThreadRunning = null;
        EraseHandler.ci.progressCallback = progressCallback;
        EraseHandler.ci.eventCallback = eventCallback;
        this.FlashBlockNum = this.dv.getFlashBlockNumber();
        this.bFlashBlockStartAddress = new int[this.FlashBlockNum];
        this.bFlashBlockEndAddress = new int[this.FlashBlockNum];
        this.bFlashBlockSize = new int[this.FlashBlockNum];
        this.bFlashBlockMirroredMask = new int[this.FlashBlockNum];
        this.bFlashSelected = new boolean[this.FlashBlockNum];
        this.nBlockCount = 0;
        while (this.nBlockCount < this.FlashBlockNum) {
            this.bFlashBlockStartAddress[this.nBlockCount] = this.dv.getFlashBlockStartAddress(this.nBlockCount);
            this.bFlashBlockEndAddress[this.nBlockCount] = this.dv.getFlashBlockEndAddress(this.nBlockCount);
            this.bFlashBlockSize[this.nBlockCount] = this.bFlashBlockEndAddress[this.nBlockCount] - this.bFlashBlockStartAddress[this.nBlockCount] + 1;
            this.bFlashBlockMirroredMask[this.nBlockCount] = this.dv.getFlashBlockMirroredMask(this.nBlockCount);
            this.bFlashSelected[this.nBlockCount] = this.dv.getFlashBlockSelection(this.nBlockCount);
            ++this.nBlockCount;
        }
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 */
                public void run(IProgressMonitor monitor) {
                    EraseHandler.this.localMonitor = monitor;
                    monitor.beginTask(Messages.EraseHandler_Erasing, 50);
                    EraseHandler.this.nBlockCount = 0;
                    while (EraseHandler.this.nBlockCount < EraseHandler.this.FlashBlockNum) {
                        block7: {
                            if (EraseHandler.this.bFlashSelected[EraseHandler.this.nBlockCount]) {
                                if (EraseHandler.this.bFlashBlockMirroredMask[EraseHandler.this.nBlockCount] == 0) {
                                    ci.StartAddress = EraseHandler.this.bFlashBlockStartAddress[EraseHandler.this.nBlockCount];
                                    ci.EndAddress = EraseHandler.this.bFlashBlockEndAddress[EraseHandler.this.nBlockCount];
                                } else {
                                    ci.StartAddress = EraseHandler.this.bFlashBlockStartAddress[EraseHandler.this.nBlockCount] & EraseHandler.this.bFlashBlockMirroredMask[EraseHandler.this.nBlockCount];
                                    ci.EndAddress = EraseHandler.this.bFlashBlockEndAddress[EraseHandler.this.nBlockCount] & EraseHandler.this.bFlashBlockMirroredMask[EraseHandler.this.nBlockCount];
                                }
                                SPCFlasherConnectDll fdll = SPCFlasherConnectDll.INSTANCE;
                                EraseHandler.this.nRC = fdll.Erase(ci);
                                if (EraseHandler.this.nRC == 0) {
                                    EraseHandler.this.stringMessage = String.format(Messages.EraseHandler_BlockRangeErased, EraseHandler.this.nBlockCount, EraseHandler.this.bFlashBlockStartAddress[EraseHandler.this.nBlockCount], EraseHandler.this.bFlashBlockEndAddress[EraseHandler.this.nBlockCount]);
                                    EraseHandler.this.dv.PrintSPC5FlasherConsole(EraseHandler.this.stringMessage);
                                    break block7;
                                } else {
                                    String stringMessage = EraseHandler.this.ed.getErrorDescription(EraseHandler.this.nRC & 0xFFFF);
                                    EraseHandler.this.dv.PrintSPC5FlasherConsole(stringMessage);
                                    break;
                                }
                            }
                            EraseHandler.this.stringMessage = String.format(Messages.EraseHandler_BlockRangeNotErased, EraseHandler.this.nBlockCount, EraseHandler.this.bFlashBlockStartAddress[EraseHandler.this.nBlockCount], EraseHandler.this.bFlashBlockEndAddress[EraseHandler.this.nBlockCount]);
                            EraseHandler.this.dv.PrintSPC5FlasherConsole(EraseHandler.this.stringMessage);
                            int n = EraseHandler.this.step;
                            while (n <= (EraseHandler.this.nBlockCount + 1) * 100 / EraseHandler.this.FlashBlockNum) {
                                EraseHandler.this.localMonitor.worked(1);
                                ++n;
                                ++n;
                            }
                            EraseHandler.this.step = n;
                        }
                        ++EraseHandler.this.nBlockCount;
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.nRC = -1;
        }
        window.getShell().setCursor(null);
        this.dv.PrintSPC5FlasherConsole(Messages.EraseHandler_EraseEnd);
        return null;
    }
}

