/*
 * Decompiled with CFR 0.152.
 */
package com.st.flashtool.drivers;

import com.st.flashtool.drivers.DeviceInfo;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlasherTargets {
    static final String stringDeviceFile = "SFPTargetList.xml";
    static List<DeviceInfo> devicesList = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DeviceInfo> getDevicesList() {
        if (devicesList == null) {
            devicesList = new ArrayList<DeviceInfo>();
        } else {
            devicesList.clear();
        }
        try {
            Bundle bundle = Platform.getBundle((String)"com.st.flashtool.resources");
            URL fileURL = bundle.getEntry(stringDeviceFile);
            File fXmlFile = null;
            try {
                URL resolvedFileURL = FileLocator.toFileURL((URL)fileURL);
                URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
                fXmlFile = new File(resolvedURI);
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            DeviceInfo device = null;
            if (!fXmlFile.exists()) {
                device = new DeviceInfo();
                device.cbSize = device.size();
                device.name = "N.A.";
                device.RAMStartAddress = "0x0";
                device.RAMSize = "0x0";
                device.flashStartAddress = "0x0";
                device.flashEndAddress = "0x0";
                device.flashSize = "0x0";
                device.flashMirroredStartAddress = "0x0";
                device.flashMirroredEndAddress = "0x0";
                device.flashMirroredPresent = false;
                devicesList.add(device);
                System.out.println("Serial Flash Programmer Project Directory : " + System.getProperty("user.dir"));
                System.out.println("Serial Flash Programmer error: An error occured opening SFPFlasherTargetList.xml.");
                return devicesList;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("device");
            int NumElem = nList.getLength();
            int TargetCount = 0;
            while (true) {
                if (TargetCount >= NumElem) {
                    return devicesList;
                }
                Node nNode = nList.item(TargetCount);
                if (nNode.getNodeType() == 1) {
                    String strBaseAddress;
                    device = new DeviceInfo();
                    device.cbSize = device.size();
                    Element eElement = (Element)nNode;
                    device.name = eElement.getAttribute("name") == null || eElement.getAttribute("name").equals("") ? "N.A." : eElement.getAttribute("name");
                    device.RAMStartAddress = eElement.getAttribute("RAMStartAddress") == null || eElement.getAttribute("RAMStartAddress").equals("") ? "0x0" : eElement.getAttribute("RAMStartAddress");
                    device.RAMSize = eElement.getAttribute("RAMSize") == null || eElement.getAttribute("RAMSize").equals("") ? "0x0" : eElement.getAttribute("RAMSize");
                    device.flashStartAddress = eElement.getAttribute("FlashStartAddress") == null || eElement.getAttribute("FlashStartAddress").equals("") ? "0x0" : eElement.getAttribute("FlashStartAddress");
                    device.flashEndAddress = eElement.getAttribute("FlashEndAddress") == null || eElement.getAttribute("FlashEndAddress").equals("") ? "0x0" : eElement.getAttribute("FlashEndAddress");
                    device.flashSize = eElement.getAttribute("FlashSize") == null || eElement.getAttribute("FlashSize").equals("") ? "0x0" : eElement.getAttribute("FlashSize");
                    if (eElement.hasAttribute("nParametersUART")) {
                        try {
                            device.nParametersUART = Integer.parseInt(eElement.getAttribute("nParametersUART"), 10);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    } else {
                        device.nParametersUART = 0;
                    }
                    if (eElement.hasAttribute("nParametersCAN")) {
                        try {
                            device.nParametersCAN = Integer.parseInt(eElement.getAttribute("nParametersCAN"), 10);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    } else {
                        device.nParametersCAN = 0;
                    }
                    if (eElement.hasAttribute("ParametersBaseAddressUART")) {
                        try {
                            strBaseAddress = eElement.getAttribute("ParametersBaseAddressUART");
                            strBaseAddress = strBaseAddress.substring(2, strBaseAddress.length());
                            device.ParametersBaseAddressUART = Integer.parseInt(strBaseAddress, 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    } else {
                        device.ParametersBaseAddressUART = 0;
                    }
                    if (eElement.hasAttribute("ParametersBaseAddressCAN")) {
                        try {
                            strBaseAddress = eElement.getAttribute("ParametersBaseAddressCAN");
                            strBaseAddress = strBaseAddress.substring(2, strBaseAddress.length());
                            device.ParametersBaseAddressCAN = Integer.parseInt(strBaseAddress, 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                    } else {
                        device.ParametersBaseAddressCAN = 0;
                    }
                    if (eElement.hasAttribute("FlashMirroredStartAddress") && eElement.hasAttribute("FlashMirroredEndAddress")) {
                        device.flashMirroredStartAddress = eElement.getAttribute("FlashMirroredStartAddress");
                        device.flashMirroredEndAddress = eElement.getAttribute("FlashMirroredEndAddress");
                        device.flashMirroredPresent = true;
                    } else {
                        device.flashMirroredPresent = false;
                        device.flashMirroredStartAddress = "N.A.";
                        device.flashMirroredEndAddress = "N.A.";
                    }
                    int flashNumB = Integer.parseInt(eElement.getAttribute("FlashNumBlock"), 10);
                    device.flashNumBlocks = flashNumB > 60 ? 60 : flashNumB;
                    int i = 0;
                    while (true) {
                        String str;
                        if (i >= flashNumB) {
                            devicesList.add(device);
                            break;
                        }
                        String FlashBlockName = String.format("FlashBlockNameN%d", i);
                        device.BlockName[i] = eElement.hasAttribute(FlashBlockName) ? eElement.getAttribute(FlashBlockName) : "N.A.";
                        String FlashBlockStartAddress = String.format("FlashBlockStartAddressN%d", i);
                        device.BlockStartAddress[i] = eElement.hasAttribute(FlashBlockStartAddress) ? eElement.getAttribute(FlashBlockStartAddress) : "N.A.";
                        String FlashBlockEndAddress = String.format("FlashBlockEndAddressN%d", i);
                        device.BlockEndAddress[i] = eElement.hasAttribute(FlashBlockName) ? eElement.getAttribute(FlashBlockEndAddress) : "N.A.";
                        String FlashBlockMirroredMask = String.format("FlashBlockMirrorMaskN%d", i);
                        device.BlockMirroredMask[i] = eElement.hasAttribute(FlashBlockName) ? ((str = eElement.getAttribute(FlashBlockMirroredMask)) == "" ? "0x0" : str) : "0x0";
                        ++i;
                    }
                }
                ++TargetCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return devicesList;
    }
}

